#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/app_options_menu'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../pages/user_menu'
require_relative '../../module/database/OracleUtility'
require_relative '../../helper/error_validation'


describe '[Story# VAR-2378: User Menu- Preferences Section]'  do
  include DriverUtility
  include OracleUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @eula = Eula.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    APPOINTMENTS = "Appointments/Requests"
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    TITLE = "Appointments/Requests"
    @error = Error_Validation.new(@driver)
    deleteNotificationPreference("1006088937V099668")
    deleteNotificationPreference("1113138327")
    @common.loginEndsOnHome(pw_redacted)
    @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)

  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-3555|TC#VAR-3556: Validate the Email Preferences on Preferences page under User Menu' do
    it "Section/table title: Appointments" do
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.primary_header).to eq(APPOINTMENTS)
      expect(@landing_appointments.appointment_header).to eq("Appointments")
    end


    it "Preferences page content" do
      @user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
     # @user_menu.userMenu
      button_element = @driver.button(:id => 'user-menu-btn')
      execute_script("$(arguments[0]).click();",button_element)
      @user_menu.preferences_element.when_visible(TIME_OUT_LIMIT)
      @user_menu.preferences
      @common.waitWhileSpinnerPresent
      @user_menu.prefTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@user_menu.prefTitle).to eq('Preferences')
      expect(@user_menu.required).to eq('* required field')
      expect(@user_menu.content).to eq("Email Notifications\nSend me updates on my appointments and requests:\nYes\nNo")
    end

    it "should verify preference page content when yes is selected" do
      @user_menu.select_emailPref("true")
      expect(@user_menu.content).to eq("Email Notifications\nSend me updates on my appointments and requests:\nYes\nNo\n* Email:")
    end

    it "should verify send me updates can be set to yes" do
      @user_menu.prefTitle_element.when_present(TIME_OUT_LIMIT)
      @user_menu.select_emailPref("true")
      expect(@user_menu.emailPref_elements[0].selected?).to eq(true)
      expect(@user_menu.emailPref_elements[1].selected?).to eq(false)
    end

    it "should verify email field is required" do
      @user_menu.email = ""
      @user_menu.prefSave
      verifyErrorMessage("Email field is required.")

    end

    it "should verify valid email can be saved" do
      @user_menu.email = "patient01@test.com"
      @user_menu.prefSave_element.when_visible(TIME_OUT_LIMIT)
      #@user_menu.prefSave
      button_element = @driver.button(:id => 'preferences-save-btn')
      execute_script("$(arguments[0]).click();",button_element)
      @user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing_appointments.appointment_header).to eq("Appointments")
    end

    it "should verify saved email is displayed when user navigates back to preference" do
      # @user_menu.userMenu
      button_element = @driver.button(:id => 'user-menu-btn')
      execute_script("$(arguments[0]).click();",button_element)
      @user_menu.preferences_element.when_visible(TIME_OUT_LIMIT)
      #@user_menu.preferences
      button_element = @driver.button(:id => 'preferences-btn')
      execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @user_menu.prefTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@user_menu.emailPref_selected?).to eq("true")
      expect(@user_menu.email).to eq("patient01@test.com")
    end

    it "should verify clicking cancel, closes the modal" do
      @user_menu.prefCancel
      @user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing_appointments.appointment_header).to eq("Appointments")
    end

    it "should verify email is saved once user logout and login" do
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      #@user_menu.userMenu
      button_element = @driver.button(:id => 'user-menu-btn')
      execute_script("$(arguments[0]).click();",button_element)
      @user_menu.preferences_element.when_visible(TIME_OUT_LIMIT)
      #@user_menu.preferences
      button_element = @driver.button(:id => 'preferences-btn')
      execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @user_menu.prefTitle_element.when_present(TIME_OUT_LIMIT)
      Watir::Wait.until { @user_menu.emailPref_selected? == "true" }
      expect(@user_menu.emailPref_selected?).to eq("true")
      expect(@user_menu.email).to eq("patient01@test.com")
    end

  end
  end
